<?php
/*=====================================================================*\
|| ###################################################################
|| # Bugdar
|| # Copyright 2002-2007 Blue Static
|| #
|| # This program is free software; you can redistribute it and/or modify
|| # it under the terms of the GNU General Public License as published by
|| # the Free Software Foundation; version 2 of the License.
|| #
|| # This program is distributed in the hope that it will be useful, but
|| # WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
|| # or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
|| # more details.
|| #
|| # You should have received a copy of the GNU General Public License along
|| # with this program; if not, write to the Free Software Foundation, Inc.,
|| # 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
|| ###################################################################
\*=====================================================================*/

$data = array(
	'usergroup' => array(
		array(
			'usergroupid' => '1',
			'title' => 'Invitados',
			'displaytitle' => 'Invitado',
			'permissions' => '83'
		),
		array(
			'usergroupid' => '2',
			'title' => 'Usuarios Registrados',
			'displaytitle' => 'Registrado',
			'permissions' => '33554687'
		),
		array(
			'usergroupid' => '3',
			'title' => 'Esperando confirmacin por Email',
			'displaytitle' => 'Pendiente de Activacin',
			'permissions' => '7'
		),
		array(
			'usergroupid' => '4',
			'title' => 'Pendiente de Aprobacin',
			'displaytitle' => 'Pendiente de Aprobacin',
			'permissions' => '3'
		),
		array(
			'usergroupid' => '5',
			'title' => 'Desarrolladores',
			'displaytitle' => 'Desarrollador',
			'permissions' => '49291263'
		),
		array(
			'usergroupid' => '6',
			'title' => 'Administradores',
			'displaytitle' => 'Administrador',
			'permissions' => '67108863'
		)
	),
	'status' => array(
		array(
			'statusid' => '1',
			'status' => 'Sin revisar',
			'displayorder' => '1',
			'color' => '#D96640'
		),
		array(
			'statusid' => '2',
			'status' => 'En espera',
			'displayorder' => '2',
			'color' => '#FFFF40'
		),
		array(
			'statusid' => '3',
			'status' => 'En proceso',
			'displayorder' => '3',
			'color' => '#B266D9'
		),
		array(
			'statusid' => '4',
			'status' => 'Cerrado',
			'displayorder' => '4',
			'color' => '#8CD940'
		),
		array(
			'statusid' => '5',
			'status' => 'Reabierto',
			'displayorder' => '5',
			'color' => '#40D9FF'
		)
	),
	'severity' => array(
		array(
			'severityid' => '1',
			'severity' => 'Mejora',
			'displayorder' => '1'
		),
		array(
			'severityid' => '2',
			'severity' => 'Trivial',
			'displayorder' => '2'
		),
		array(
			'severityid' => '3',
			'severity' => 'Baja',
			'displayorder' => '3'
		),
		array(
			'severityid' => '4',
			'severity' => 'Moderada',
			'displayorder' => '4'
		),
		array(
			'severityid' => '5',
			'severity' => 'Grave',
			'displayorder' => '5'
		),
		array(
			'severityid' => '6',
			'severity' => 'Crtica',
			'displayorder' => '6'
		)
	),
	'priority' => array(
		array(
			'priorityid' => '1',
			'priority' => 'Aplazado',
			'displayorder' => '1'
		),
		array(
			'priorityid' => '2',
			'priority' => 'Baja',
			'displayorder' => '2'
		),
		array(
			'priorityid' => '3',
			'priority' => 'Normal',
			'displayorder' => '3'
		),
		array(
			'priorityid' => '4',
			'priority' => 'Alta',
			'displayorder' => '4'
		),
		array(
			'priorityid' => '5',
			'priority' => 'URGENTE',
			'displayorder' => '5'
		)
	),
	'resolution' => array(
		array(
			'resolutionid' => '1',
			'resolution' => 'Abierto',
			'displayorder' => '1'
		),
		array(
			'resolutionid' => '2',
			'resolution' => 'Solucionado',
			'displayorder' => '2'
		),
		array(
			'resolutionid' => '3',
			'resolution' => 'No es un fallo',
			'displayorder' => '3'
		),
		array(
			'resolutionid' => '4',
			'resolution' => 'Duplicado',
			'displayorder' => '4'
		),
		array(
			'resolutionid' => '5',
			'resolution' => 'Sin solucin',
			'displayorder' => '5'
		),
		array(
			'resolutionid' => '6',
			'resolution' => 'No detectado',
			'displayorder' => '6'
		)
	),
	'fieldhelp' => array(
		array(
			'keystring' => 'bugid',
			'title' => 'ID & Ocultos',
			'body' => 'La ID un nmero de identificacin nico que permite localizar los tickets. La ID tambin se usa para duplicados y dependencias. Marcar un bug como &quot;oculto&quot; evitar que otros usuarios puedan verlos (revisa el apartado de pemiros del manual de Bugdar). Ocultar tickets puede ser til por motivos de seguridad para asuntos que no deseas que se traten en pblico.'
		),
		array(
			'keystring' => 'summary',
			'title' => 'Resumen',
			'body' => 'El Resumen se usa para proporcionar una descripcin general del problema. Se muestra en todas las pginas.'
		),
		array(
			'keystring' => 'reporter',
			'title' => 'Notificador',
			'body' => 'El notificador es el usuario que realiza el aviso inicial y, por tanto, la persona a contactar para obtener ms detalles sobre el aviso.'
		),
		array(
			'keystring' => 'dateline',
			'title' => 'Hora de notificacin',
			'body' => 'Hora del envo inicial de la notificacin.'
		),
		array(
			'keystring' => 'product',
			'title' => 'Producto/Version',
			'body' => 'El producto, componente y versin muestra el rea general en la que ocurre el problema. El producto podra ser, por ejemplo, un coche, mientras que el componente sera una puerta.'
		),
		array(
			'keystring' => 'assignedto',
			'title' => 'Asignacin',
			'body' => 'La persona a la que, optativamente, pueden asignrse por defecto las notificaciones.'
		),
		array(
			'keystring' => 'status',
			'title' => 'Estado',
			'body' => 'El estado del aviso y cmo se est gestionando.'
		),
		array(
			'keystring' => 'resolution',
			'title' => 'Resolucin',
			'body' => 'Explicacin el estado. La resolucin aparece cuando una notificacin se marca como &quot;Cerrada&quot;.'
		),
		array(
			'keystring' => 'severity',
			'title' => 'Gravedad',
			'body' => 'Esta opcin permite diferencia la importancia de la notificacin.'
		),
		array(
			'keystring' => 'priority',
			'title' => 'Prioridad',
			'body' => 'Indica el grado de rapidez con la que una notificacin debera ser resuelta.'
		),
		array(
			'keystring' => 'duplicateof',
			'title' => 'Duplicado de',
			'body' => 'Permite enlazar notificaciones referentes a un mismo problema.'
		),
		array(
			'keystring' => 'dependency',
			'title' => 'Dependencias',
			'body' => 'Si un error est asociado a otro puedes indicarlo aqu. Puedes indicar varios valores separando las IDs de las notificaciones mediante espacios.'
		),
		array(
			'keystring' => 'newreply',
			'title' => 'Nueva Respuesta',
			'body' => 'Aqu puedes aadir comentarios adicionales. SI no cambias nada, slo adjuntar un comentario.

El men &quot;Automatizacin&quot; junto a esta caja (que puede esta oculto) permite realiar una tarea comn. Estas tareas pueden cambiar cualquiera de los campos de forma automtica y obtener una respuesta automatizada. Si cambias un campo que ser modificada por la accin, el cambio de sta suceder con antelacin. Igualmente, si introduces un comentario y la accin especifica uno, el comentario automtico se adjuntar al tuyo.'
		),
		array(
			'keystring' => 'columnorder',
			'title' => 'Orden de columna personalizado',
			'body' => 'Puedes cambiar el orden de las columnas aqu. Las columnas con un valor &quot;0&quot; no se mostrarn. Las columnas se colocan en la parrilla con el nmero ms bajo en la parte ms a la izquierda. Las columnas con un mismo nmero se situarn en la misma posicin en la columna.'
		)
	)
);

/*=====================================================================*\
|| ###################################################################
|| # $HeadURL: https://bugdar.svn.sourceforge.net/svnroot/bugdar/tags/1.2.2/install/default_data.php $
|| # $Id: default_data.php 1582 2007-07-19 22:33:24Z rsesek $
|| ###################################################################
\*=====================================================================*/
?>